/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.tripod;

public enum TripodSlot {
    NONE,
    ONE,
    TWO,
    THREE,
    FOUR,
    FIVE,
    SIX,
    SEVEN,
    EIGHT,
    NINE;

    public static final int MIN = 1;
    public static final int MAX;

    public String toString() {
        return this == NONE ? "None" : "#%d".formatted(this.ordinal());
    }

    public static boolean inRange(int number) {
        return number >= 1 && number <= MAX;
    }

    public static TripodSlot valueOf(int number) throws IndexOutOfBoundsException {
        if (TripodSlot.inRange(number)) {
            throw new IndexOutOfBoundsException("Cannot get TripodSlot for number %d: must be %d-%d.".formatted(number, 1, MAX));
        }
        return TripodSlot.valueOfUnsafe(number);
    }

    public static TripodSlot ofKeyCode(int keyCode) {
        int number = keyCode - 48;
        return TripodSlot.inRange(number) ? TripodSlot.valueOfUnsafe(number) : NONE;
    }

    private static TripodSlot valueOfUnsafe(int number) {
        return TripodSlot.values()[number];
    }

    static {
        MAX = TripodSlot.values().length - 1;
    }
}

