/*
 * Decompiled with CFR 0.152.
 */
package b100.fullscreenfix;

import b100.fullscreenfix.util.ConfigUtil;
import java.io.File;
import java.nio.file.Paths;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Global {
    public static final boolean INDEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final String MODID = "fullscreenfix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fullscreenfix");
    public static final File CONFIG_FOLDER = Paths.get("config", new String[0]).toFile();
    public static final File CONFIG_FILE = new File(CONFIG_FOLDER, "fullscreenfix.properties");
    public static final String MIXIN_PACKAGE = "b100.fullscreenfix.mixin";
    public static final boolean OS_WINDOWS = Global.isWindows();
    public static final boolean MOD_ENABLED = Global.isModEnabled();

    private static boolean isModEnabled() {
        MutableObject enabled = new MutableObject((Object)true);
        ConfigUtil.loadConfig(CONFIG_FILE, (key, value) -> {
            if (key.equals("enableMod")) {
                enabled.setValue((Object)value.equalsIgnoreCase("true"));
            }
        }, ':');
        return (Boolean)enabled.getValue();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    static void print(String string) {
        if (INDEV) {
            System.out.print("[FullscreenFix] " + string + "\n");
        } else {
            LOGGER.info("[FullscreenFix] " + string);
        }
    }

    static {
        if (!MOD_ENABLED) {
            Global.print("Mod disabled in config!");
        }
    }
}

