/*
 * Decompiled with CFR 0.152.
 */
package b100.gui;

import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.GuiScrollableList;
import b100.gui.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GuiScrollBar
extends GuiElement {
    public GuiScreen screen;
    public GuiScrollableList list;
    protected boolean dragging = false;
    protected int dragButton = 0;
    protected double previousScrollAmount;
    protected double clickPosX;
    protected double clickPosY;

    public GuiScrollBar(GuiScreen screen, GuiScrollableList list) {
        this.screen = screen;
        this.list = list;
    }

    @Override
    public void draw() {
        int scrollRegionHeight = this.list.getScrollRegionHeight();
        int contentHeight = this.list.getContentHeight();
        if (contentHeight < scrollRegionHeight) {
            return;
        }
        float f = (float)scrollRegionHeight / (float)contentHeight;
        int scrollerHeight = (int)((float)this.height * f);
        scrollerHeight = Math.max(scrollerHeight, 32);
        scrollerHeight = Math.min(scrollerHeight, this.height - this.width);
        if (this.dragging) {
            double offset = this.clickPosY - this.screen.mouseY;
            int scrollableAreaLength = this.height - scrollerHeight;
            double d = offset / (double)scrollableAreaLength;
            this.list.setScrollAmount(this.previousScrollAmount - (d *= (double)(contentHeight - scrollRegionHeight)));
        }
        float scrollFactor = (float)(this.list.getScrollAmount() / this.list.getMaxScrollAmount());
        int scrollerOffset = (int)(scrollFactor * (float)(this.height - scrollerHeight));
        this.utils.drawGuiTexture(Textures.INSTANCE.scrollerBackground, this.posX, this.posY, this.width, this.height);
        this.utils.drawGuiTexture(Textures.INSTANCE.scroller, this.posX, this.posY + scrollerOffset, this.width, scrollerHeight);
    }

    @Override
    public boolean mouseEvent(int button, boolean pressed, double mouseX, double mouseY) {
        if (!pressed && this.dragging && button == this.dragButton) {
            this.dragging = false;
        }
        if (pressed && !this.dragging && this.screen.isMouseOver(this)) {
            this.dragging = true;
            this.dragButton = button;
            this.previousScrollAmount = this.list.getScrollAmount();
            this.clickPosX = mouseX;
            this.clickPosY = mouseY;
        }
        return super.mouseEvent(button, pressed, mouseX, mouseY);
    }

    @Override
    public boolean isSolid() {
        return this.list.getContentHeight() > this.list.getScrollRegionHeight();
    }
}

