/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.chunk_ticking.random_block_ticking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Objects;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.world.section.LithiumSectionData;
import net.caffeinemc.mods.lithium.common.world.section.RandomTickingSectionDataHelper;
import net.minecraft.class_11897;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2826.class}, priority=2000)
public abstract class LevelChunkSectionMixin
implements LithiumSectionData {
    @Shadow
    @Final
    private class_2841<class_2680> field_12878;

    @Inject(method={"<init>(Lnet/minecraft/class_11897;)V"}, at={@At(value="RETURN")})
    private void initAirSection(class_11897 palettedContainerFactory, CallbackInfo ci) {
        LithiumSectionData.SectionData sectionData = this.lithium$getSectionData();
        if (sectionData.getRandomTickableBlocksByY() != null) {
            throw new IllegalStateException("RandomTickableBlocksByY already initialized!");
        }
        sectionData.setRandomTickableBlocksByY(new byte[RandomTickingSectionDataHelper.BYTE_COUNT]);
        if (this.field_12878.method_19526((Predicate)BlockStateFlags.RANDOM_TICKING)) {
            byte[] randomTickableBlocksByY = sectionData.getRandomTickableBlocksByY();
            int numBlocks = 4096;
            for (int i = 0; i < randomTickableBlocksByY.length; ++i) {
                randomTickableBlocksByY[i] = (byte)Math.min(248, numBlocks);
                numBlocks -= randomTickableBlocksByY[i];
            }
        }
    }

    @Inject(method={"method_12253()V"}, at={@At(value="HEAD")})
    private void createFlagCounters(CallbackInfo ci) {
        this.lithium$getSectionData().setRandomTickableBlocksByY(new byte[RandomTickingSectionDataHelper.BYTE_COUNT]);
    }

    @WrapOperation(method={"method_12253()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2841;method_21732(Lnet/minecraft/class_2841$class_4464;)V")})
    private void initFlagCounters(class_2841<class_2680> instance, class_2841.class_4464<class_2680> countConsumer, Operation<Void> original) {
        byte[] randomTickableBlocksByY = Objects.requireNonNull(this.lithium$getSectionData().getRandomTickableBlocksByY());
        RandomTickingSectionDataHelper.LithiumBlockCounter lithiumBlockCounter = new RandomTickingSectionDataHelper.LithiumBlockCounter(randomTickableBlocksByY, countConsumer);
        original.call(new Object[]{instance, lithiumBlockCounter});
        lithiumBlockCounter.handleAfterCounting((class_2826)this);
    }

    @Inject(method={"method_12256(IIILnet/minecraft/class_2680;Z)Lnet/minecraft/class_2680;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2680;method_26227()Lnet/minecraft/class_3610;", ordinal=0)})
    private void updateRandomTickableBlockCounts(int x, int y, int z, class_2680 newState, boolean lock, CallbackInfoReturnable<class_2680> cir, @Local(ordinal=1) class_2680 oldState) {
        int prevFlags = ((BlockStateFlagHolder)oldState).lithium$getAllFlags();
        int flags = ((BlockStateFlagHolder)newState).lithium$getAllFlags();
        int mask = 1 << BlockStateFlags.RANDOM_TICKING.getIndex();
        if ((prevFlags & mask) != (flags & mask)) {
            if ((prevFlags & mask) != 0) {
                RandomTickingSectionDataHelper.removeAt(x, y, z, this.lithium$getSectionDataDirect().getRandomTickableBlocksByY());
            } else {
                RandomTickingSectionDataHelper.addAt(x, y, z, this.lithium$getSectionDataDirect().getRandomTickableBlocksByY());
            }
        }
    }
}

