/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.commands.CommandTranslations;
import net.kyrptonaught.inventorysorter.network.SortSettings;
import net.kyrptonaught.inventorysorter.permissions.CommandPermission;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class SortPlayerInventoryCommand {
    private static final String SET_KEY = "inventorysorter.cmd.sortPlayerInventory.set";
    private static final String GET_KEY = "inventorysorter.cmd.sortPlayerInventory.get";

    public static void register(CommandDispatcher<class_2168> dispatcher, LiteralArgumentBuilder<class_2168> rootCommand) {
        dispatcher.register((LiteralArgumentBuilder)rootCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sortPlayerInventory").requires(CommandPermission.require("sortplayerinventory", 0))).executes(SortPlayerInventoryCommand::showState)).then(class_2170.method_9247((String)"on").executes(SortPlayerInventoryCommand::turnOn))).then(class_2170.method_9247((String)"off").executes(SortPlayerInventoryCommand::turnOff))));
    }

    public static int turnOff(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        SortSettings settings = ((SortSettings)player.getAttachedOrCreate(InventorySorterMod.SORT_SETTINGS)).withSortPlayerInventory(false);
        player.setAttached(InventorySorterMod.SORT_SETTINGS, (Object)settings);
        settings.sync(player);
        ((class_2168)commandContext.getSource()).method_9226(() -> CommandTranslations.getOffMessage(SET_KEY), false);
        return 1;
    }

    public static int turnOn(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        SortSettings settings = ((SortSettings)player.getAttachedOrCreate(InventorySorterMod.SORT_SETTINGS)).withSortPlayerInventory(true);
        player.setAttached(InventorySorterMod.SORT_SETTINGS, (Object)settings);
        settings.sync(player);
        ((class_2168)commandContext.getSource()).method_9226(() -> CommandTranslations.getOnMessage(SET_KEY), false);
        return 1;
    }

    public static int showState(CommandContext<class_2168> commandContext) {
        class_3222 player = ((class_2168)commandContext.getSource()).method_44023();
        if (player == null) {
            ((class_2168)commandContext.getSource()).method_9226(CommandTranslations::playerRequired, false);
            return 0;
        }
        SortSettings settings = (SortSettings)player.getAttachedOrCreate(InventorySorterMod.SORT_SETTINGS);
        ((class_2168)commandContext.getSource()).method_9226(() -> CommandTranslations.getFeedbackMessageForState(GET_KEY, settings.sortPlayerInventory()), false);
        return 1;
    }
}

