/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.compat.sources;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.compat.config.CompatConfig;
import net.kyrptonaught.inventorysorter.compat.sources.CompatibilityLoader;
import net.kyrptonaught.inventorysorter.config.SchemaValidator;
import net.minecraft.class_2960;

public class RemoteConfigLoader
implements CompatibilityLoader {
    private final Supplier<String> customCompatibilityListDownloadUrl;
    private CompatConfig config = new CompatConfig();
    private long lastRemoteConfigFetch = 0L;
    private static final long CACHE_TTL_MILLIS = 2000L;

    public RemoteConfigLoader(Supplier<String> customCompatibilityListDownloadUrl) {
        this.customCompatibilityListDownloadUrl = customCompatibilityListDownloadUrl;
    }

    private void loadRemoteConfig() {
        boolean shouldRefresh;
        long now = System.currentTimeMillis();
        boolean bl = shouldRefresh = now - this.lastRemoteConfigFetch > 2000L;
        if (shouldRefresh) {
            this.config.hideButtonsForScreens.clear();
            this.config.preventSortForScreens.clear();
            if (this.customCompatibilityListDownloadUrl.get() != null && !this.customCompatibilityListDownloadUrl.get().isEmpty()) {
                try {
                    URL url = URI.create(this.customCompatibilityListDownloadUrl.get()).toURL();
                    this.config = this.downloadFrom(url);
                    this.lastRemoteConfigFetch = now;
                }
                catch (Exception e) {
                    InventorySorterMod.LOGGER.error("Not a valid URL in the config file: {}", this.customCompatibilityListDownloadUrl);
                }
            }
        }
    }

    public CompatConfig downloadFrom(URL url) {
        InventorySorterMod.LOGGER.info("Downloading remote compatibility config from {}", (Object)url);
        try {
            InputStreamReader reader = new InputStreamReader(url.openStream());
            boolean success = SchemaValidator.isValidJsonObject(reader, "config-remote-schema.json", url.toString());
            if (success) {
                reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
                return (CompatConfig)new Gson().fromJson((Reader)reader, CompatConfig.class);
            }
        }
        catch (Exception e) {
            InventorySorterMod.LOGGER.error("Failed to load remote config from: {}", (Object)url, (Object)e);
        }
        return new CompatConfig();
    }

    @Override
    public Set<class_2960> getPreventSort() {
        this.loadRemoteConfig();
        return this.config.preventSortForScreens.stream().map(class_2960::method_60654).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2960> getShouldHideSortButtons() {
        this.loadRemoteConfig();
        return this.config.hideButtonsForScreens.stream().map(class_2960::method_60654).collect(Collectors.toSet());
    }
}

