/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.SyntaxError;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.config.ConfigPathResolver;
import net.kyrptonaught.inventorysorter.config.NewConfigOptions;
import net.kyrptonaught.inventorysorter.config.OldCompatibilityListOptions;
import net.kyrptonaught.inventorysorter.config.OldConfigOptions;

public class Config {
    private static final Path oldConfigPath = ConfigPathResolver.getConfigPath("inventorysorter/config.json5");
    private static final Path oldCompatibilityListPath = ConfigPathResolver.getConfigPath("inventorysorter/blacklist.json5");

    public static NewConfigOptions load() {
        NewConfigOptions newConfig = Config.convertedOptions();
        if (oldCompatibilityListPath.toFile().exists()) {
            InventorySorterMod.LOGGER.info("Found old compatibility file, converting to new format...");
            OldCompatibilityListOptions denyListOptions = OldCompatibilityListOptions.load();
            newConfig.customCompatibilityListDownloadUrl = denyListOptions.blacklistDownloadURL;
            newConfig.hideButtonsForScreens = denyListOptions.hideSortBtnsList;
            newConfig.preventSortForScreens = denyListOptions.doNotSortList;
            InventorySorterMod.LOGGER.info("Old compatibility file converted successfully.");
        }
        try {
            if (oldConfigPath.toFile().exists() || oldCompatibilityListPath.toFile().exists()) {
                Files.walk(oldConfigPath.getParent(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            InventorySorterMod.LOGGER.error("Failed to delete old config files", (Throwable)e);
        }
        newConfig.save();
        return newConfig;
    }

    private static NewConfigOptions convertedOptions() {
        try {
            if (oldConfigPath.toFile().exists()) {
                InventorySorterMod.LOGGER.info("Found old config file, converting to new format...");
                OldConfigOptions oldConfig = OldConfigOptions.load();
                NewConfigOptions newConfig = NewConfigOptions.convertOldToNew(oldConfig);
                InventorySorterMod.LOGGER.info("Old config file converted successfully.");
                return newConfig;
            }
            return NewConfigOptions.load();
        }
        catch (IOException | SyntaxError e) {
            return new NewConfigOptions();
        }
    }
}

