/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.kyrptonaught.inventorysorter.InventorySorterMod;
import net.kyrptonaught.inventorysorter.SortType;
import net.kyrptonaught.inventorysorter.client.InventorySorterModClient;
import net.kyrptonaught.inventorysorter.compat.config.CompatConfig;
import net.kyrptonaught.inventorysorter.config.ConfigPathResolver;
import net.kyrptonaught.inventorysorter.config.OldConfigOptions;
import net.kyrptonaught.inventorysorter.config.SchemaValidator;
import net.kyrptonaught.inventorysorter.config.ScrollBehaviour;
import net.minecraft.class_3675;

public class NewConfigOptions
extends CompatConfig {
    public boolean showSortButton = true;
    public boolean showTooltips = true;
    public boolean separateButton = true;
    public boolean sortPlayerInventory = false;
    public SortType sortType = SortType.NAME;
    public boolean enableDoubleClickSort = true;
    public boolean sortHighlightedItem = true;
    public ScrollBehaviour scrollBehaviour = ScrollBehaviour.FREE;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "inventorysorter.json";

    public void save() {
        Path filePath = ConfigPathResolver.getConfigPath(CONFIG_FILE);
        try (FileWriter writer = new FileWriter(filePath.toFile(), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NewConfigOptions load() throws IOException {
        NewConfigOptions newConfigOptions;
        Path filePath = ConfigPathResolver.getConfigPath(CONFIG_FILE);
        FileReader configReader = new FileReader(filePath.toFile());
        try {
            InventorySorterMod.LOGGER.debug("Validating config file...");
            SchemaValidator.isValidJsonObject(configReader, "config-schema.json", filePath.toString());
            InventorySorterMod.LOGGER.debug("Config file is valid.");
            NewConfigOptions result = (NewConfigOptions)GSON.fromJson((Reader)new FileReader(filePath.toFile(), StandardCharsets.UTF_8), NewConfigOptions.class);
            if (result.customCompatibilityListDownloadUrl.startsWith("https://raw.githubusercontent.com/kyrptonaught")) {
                InventorySorterMod.LOGGER.info("Old, redundant custom compatibility list URL detected. Fixing it!");
                result.customCompatibilityListDownloadUrl = "";
            }
            newConfigOptions = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)configReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return new NewConfigOptions();
            }
            catch (Exception e) {
                InventorySorterMod.LOGGER.error("There's an error in the config file inventorysorter.json:");
                throw new RuntimeException(e);
            }
        }
        ((Reader)configReader).close();
        return newConfigOptions;
    }

    public static NewConfigOptions convertOldToNew(OldConfigOptions oldOptions) {
        NewConfigOptions newOptions = new NewConfigOptions();
        newOptions.showSortButton = oldOptions.displaySort;
        newOptions.showTooltips = oldOptions.displayTooltip;
        newOptions.separateButton = oldOptions.seperateBtn;
        newOptions.sortPlayerInventory = oldOptions.sortPlayer;
        newOptions.sortType = oldOptions.sortType;
        newOptions.enableDoubleClickSort = oldOptions.doubleClickSort;
        newOptions.sortHighlightedItem = oldOptions.sortMouseHighlighted;
        if (oldOptions.keybinding != null) {
            class_3675.class_306 boundKey = class_3675.method_15981((String)oldOptions.keybinding);
            InventorySorterModClient.sortButton.method_1422(boundKey);
        }
        return newOptions;
    }
}

