/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.inventorysorter.e2e;

import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10129;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2598;
import net.minecraft.class_3222;
import net.minecraft.class_4516;
import net.minecraft.class_8792;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class TestUtils {
    public static boolean IS_SPECTATOR = true;
    private static class_3222 player;

    private static class_2561 getMessage(String message) {
        return class_2561.method_30163((String)message);
    }

    public static void assertContents(class_4516 ctx, Scenario scenario, Map<Integer, class_1799> expectedContents) {
        int slotCount = scenario.chest.method_5439();
        for (int i = 0; i < slotCount; ++i) {
            if (expectedContents.containsKey(i)) continue;
            class_1799 stack = scenario.chest.method_5438(i);
            ctx.method_56606((Object)stack, (Object)class_1799.field_8037, TestUtils.getMessage("Slot " + i + " should be empty"));
        }
        for (Map.Entry<Integer, class_1799> entry : expectedContents.entrySet()) {
            class_1799 stack = scenario.chest.method_5438(entry.getKey().intValue());
            ctx.method_56606((Object)stack.method_7909(), (Object)entry.getValue().method_7909(), TestUtils.getMessage("Slot " + String.valueOf(entry.getKey()) + " does not have the expected item"));
            ctx.method_56606((Object)stack.method_7947(), (Object)entry.getValue().method_7947(), TestUtils.getMessage("Slot " + String.valueOf(entry.getKey()) + " does not have the expected count"));
            int expectedDamage = entry.getValue().method_7919();
            int actualDamage = stack.method_7919();
            ctx.method_56606((Object)actualDamage, (Object)expectedDamage, TestUtils.getMessage("Slot " + String.valueOf(entry.getKey()) + " does not have the expected damage"));
            if (entry.getValue().method_57353().method_57832(class_9334.field_50238)) {
                int expectedAmplifier = ((class_10129)entry.getValue().method_57353().method_58694(class_9334.field_50238)).comp_3090();
                int actualAmplifier = ((class_10129)stack.method_57353().method_58694(class_9334.field_50238)).comp_3090();
                ctx.method_56606((Object)actualAmplifier, (Object)expectedAmplifier, TestUtils.getMessage("Slot " + String.valueOf(entry.getKey()) + " does not have the expected ominous bottle amplifier"));
            }
            if (!entry.getValue().method_57353().method_57832(class_9334.field_49623)) continue;
            Map expectedBlockState = ((class_9275)entry.getValue().method_57353().method_58694(class_9334.field_49623)).comp_2381();
            Map actualBlockState = ((class_9275)stack.method_57353().method_58694(class_9334.field_49623)).comp_2381();
            ctx.method_56606((Object)actualBlockState, (Object)expectedBlockState, TestUtils.getMessage("Slot " + String.valueOf(entry.getKey()) + " does not have the expected block state"));
        }
    }

    public static Scenario setUpScene(class_4516 ctx, Map<Integer, class_1799> inventoryContents) {
        return TestUtils.setUpScene(ctx, inventoryContents, false);
    }

    public static Scenario setUpScene(class_4516 ctx, Map<Integer, class_1799> inventoryContents, boolean isSpectator) {
        player = TestUtils.createMockServerPlayer(ctx, isSpectator);
        class_2338 inventoryPosition = new class_2338(0, 0, 0);
        class_2338 abspos = ctx.method_36052(inventoryPosition);
        ctx.method_35986(inventoryPosition, class_2246.field_10034.method_9564());
        player.method_6082((double)(abspos.method_10263() + 2), (double)abspos.method_10264(), (double)(abspos.method_10260() + 2), false);
        player.method_5702(class_2183.class_2184.field_9851, abspos.method_46558());
        class_2595 chest = (class_2595)ctx.method_36014(inventoryPosition, class_2595.class);
        for (Map.Entry<Integer, class_1799> entry : inventoryContents.entrySet()) {
            chest.method_5447(entry.getKey().intValue(), entry.getValue());
        }
        ctx.method_36034(inventoryPosition, (class_1657)player);
        return new Scenario(player, chest);
    }

    public static class_3222 createMockServerPlayer(class_4516 ctx, final boolean isSpectator) {
        class_8792 connectedClientData = class_8792.method_53824((GameProfile)new GameProfile(UUID.randomUUID(), "test-mock-player"), (boolean)false);
        class_3222 serverPlayerEntity = new class_3222(ctx.method_35943().method_8503(), ctx.method_35943(), connectedClientData.comp_1959(), connectedClientData.comp_1961()){

            public boolean method_7325() {
                return isSpectator;
            }

            public boolean method_68878() {
                return false;
            }
        };
        class_2535 clientConnection = new class_2535(class_2598.field_11941);
        new EmbeddedChannel(new ChannelHandler[]{clientConnection});
        ctx.method_35943().method_8503().method_3760().method_14570(clientConnection, serverPlayerEntity, connectedClientData);
        return serverPlayerEntity;
    }

    public static int damageForPercent(class_1792 item, int percent) {
        int maxDamage = (Integer)item.method_57347().method_58695(class_9334.field_50072, (Object)0);
        return (int)Math.floor((double)maxDamage * ((double)percent / 100.0));
    }

    public record Scenario(class_3222 player, class_2595 chest) {
    }
}

