/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDhTintGetter
implements class_1920 {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    protected final BiomeWrapper biomeWrapper;
    protected final int smoothingRadiusInBlocks;
    protected final FullDataSourceV2 fullDataSource;
    protected final IClientLevelWrapper clientLevelWrapper;
    public static final ConcurrentMap<String, class_6880<class_1959>> BIOME_BY_RESOURCE_STRING = new ConcurrentHashMap<String, class_6880<class_1959>>();

    public AbstractDhTintGetter(BiomeWrapper biomeWrapper, FullDataSourceV2 fullDataSource, IClientLevelWrapper clientLevelWrapper) {
        this.biomeWrapper = biomeWrapper;
        this.fullDataSource = fullDataSource;
        this.clientLevelWrapper = clientLevelWrapper;
        this.smoothingRadiusInBlocks = Config.Client.Advanced.Graphics.Quality.lodBiomeBlending.get();
    }

    public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
        byte dataSourceDetailLevel = DhSectionPos.getDetailLevel(this.fullDataSource.getPos());
        dataSourceDetailLevel = (byte)(dataSourceDetailLevel - 6);
        int dataSourceLodWidthInBlocks = DhSectionPos.getDetailLevelWidthInBlocks(dataSourceDetailLevel);
        if (this.smoothingRadiusInBlocks == 0 || dataSourceLodWidthInBlocks > this.smoothingRadiusInBlocks) {
            return colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(this.biomeWrapper.biome, this.clientLevelWrapper), (double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        int dataPointCount = 0;
        int rollingRed = 0;
        int rollingGreen = 0;
        int rollingBlue = 0;
        int xMin = blockPos.method_10263() - this.smoothingRadiusInBlocks;
        int xMax = blockPos.method_10263() + this.smoothingRadiusInBlocks;
        int zMin = blockPos.method_10260() - this.smoothingRadiusInBlocks;
        int zMax = blockPos.method_10260() + this.smoothingRadiusInBlocks;
        DhBlockPosMutable mutableBlockPos = new DhBlockPosMutable(0, blockPos.method_10264(), 0);
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                mutableBlockPos.setX(x);
                mutableBlockPos.setZ(z);
                long dataPoint = this.fullDataSource.getAtBlockPos(mutableBlockPos);
                if (dataPoint == 0L) continue;
                int id = FullDataPointUtil.getId(dataPoint);
                BiomeWrapper biomeWrapper = (BiomeWrapper)this.fullDataSource.mapping.getBiomeWrapper(id);
                int color = colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(biomeWrapper.biome, this.clientLevelWrapper), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                rollingRed += ColorUtil.getRed(color);
                rollingGreen += ColorUtil.getGreen(color);
                rollingBlue += ColorUtil.getBlue(color);
                ++dataPointCount;
            }
        }
        if (dataPointCount == 0) {
            return colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(this.biomeWrapper.biome, this.clientLevelWrapper), (double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        int colorInt = ColorUtil.argbToInt(255, rollingRed / dataPointCount, rollingGreen / dataPointCount, rollingBlue / dataPointCount);
        return colorInt;
    }

    protected static class_1959 unwrapClientBiome(class_6880<class_1959> biome, IClientLevelWrapper clientLevelWrapper) {
        BiomeWrapper biomeWrapper = (BiomeWrapper)BiomeWrapper.getBiomeWrapper(biome, clientLevelWrapper);
        String biomeString = biomeWrapper.getSerialString();
        if (biomeString == null || biomeString.isEmpty() || biomeString.equals("EMPTY")) {
            biomeString = "minecraft:plains";
        }
        return AbstractDhTintGetter.unwrapBiome(AbstractDhTintGetter.getClientBiome(biomeString));
    }

    protected static class_1959 unwrapBiome(class_6880<class_1959> biome) {
        return (class_1959)biome.comp_349();
    }

    private static class_6880<class_1959> getClientBiome(String biomeResourceString) {
        return BIOME_BY_RESOURCE_STRING.compute(biomeResourceString, (resourceString, existingBiome) -> {
            BiomeWrapper.BiomeDeserializeResult result;
            if (existingBiome != null) {
                return existingBiome;
            }
            class_638 clientLevel = class_310.method_1551().field_1687;
            if (clientLevel == null) {
                throw new IllegalStateException("Attempted to get client biome when no client level was loaded.");
            }
            try {
                result = BiomeWrapper.deserializeBiome(resourceString, clientLevel.method_30349());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to deserialize client biome [" + resourceString + "], using fallback...");
                try {
                    result = BiomeWrapper.deserializeBiome("minecraft:plains", clientLevel.method_30349());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to deserialize fallback client biome [minecraft:plains], returning NULL.");
                    return null;
                }
            }
            if (result.success) {
                existingBiome = result.biome;
            }
            return existingBiome;
        });
    }
}

