/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.led;

import dev.isxander.controlify.controller.ECSComponent;
import dev.isxander.controlify.utils.CUtil;
import java.util.Arrays;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class LEDComponent
implements ECSComponent {
    public static final class_2960 ID = CUtil.rl("led");
    private final int[] ledColors;
    private boolean dirty = false;

    public LEDComponent(int ledCount) {
        this.ledColors = new int[ledCount];
    }

    public void setAll(int color) {
        Arrays.fill(this.ledColors, color);
        this.dirty = true;
    }

    public int[] getAll() {
        return Arrays.copyOf(this.ledColors, this.ledColors.length);
    }

    public void set(int index, int color) {
        if (index < 0 || index >= this.ledColors.length) {
            throw new IndexOutOfBoundsException("LED index out of bounds: " + index);
        }
        if (this.ledColors[index] != color) {
            this.ledColors[index] = color;
            this.dirty = true;
        }
    }

    public int get(int index) {
        if (index < 0 || index >= this.ledColors.length) {
            throw new IndexOutOfBoundsException("LED index out of bounds: " + index);
        }
        return this.ledColors[index];
    }

    public int getCount() {
        return this.ledColors.length;
    }

    @ApiStatus.Internal
    public boolean consumeDirty() {
        boolean old = this.dirty;
        this.dirty = false;
        return old;
    }

    @Override
    public class_2960 id() {
        return ID;
    }
}

