/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.utils.codec.CExtraCodecs;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_8824;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record KeyboardLayout(float width, List<List<Key>> keys) {
    public static final Codec<KeyboardLayout> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)1.0f, (float)Float.MAX_VALUE).fieldOf("width").forGetter(KeyboardLayout::width), (App)Key.CODEC.listOf(1, Integer.MAX_VALUE).listOf(1, Integer.MAX_VALUE).fieldOf("keys").forGetter(KeyboardLayout::keys)).apply((Applicative)instance, KeyboardLayout::new)).validate(layout -> KeyboardLayout.validateRowWidths(layout) ? DataResult.success((Object)layout) : DataResult.error(() -> "Row widths do not match the specified row width: " + layout.width()));

    public static boolean validateRowWidths(KeyboardLayout layout) {
        return layout.keys().stream().mapToDouble(row -> row.stream().mapToDouble(Key::width).sum()).allMatch(rowWidth -> rowWidth == (double)layout.width());
    }

    @SafeVarargs
    public static KeyboardLayout of(float width, List<Key> ... keys) {
        KeyboardLayout layout = new KeyboardLayout(width, List.of(keys));
        Validate.isTrue((boolean)KeyboardLayout.validateRowWidths(layout), (String)("All row widths do not match the specified row width: " + width), (Object[])new Object[0]);
        return layout;
    }

    public record Key(KeyFunction regular, KeyFunction shifted, float width, Optional<InputBindingSupplier> shortcutBinding, @Nullable String identifier) {
        private static final Codec<Float> WIDTH_CODEC = Codec.floatRange((float)0.1f, (float)Float.MAX_VALUE);
        private static final Codec<Key> PAIR_CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)KeyFunction.CODEC.fieldOf("regular").forGetter(Key::regular), (App)KeyFunction.CODEC.optionalFieldOf("shifted").forGetter(k -> Optional.of(k.shifted)), (App)WIDTH_CODEC.optionalFieldOf("width", (Object)Float.valueOf(1.0f)).forGetter(Key::width), (App)InputBindingSupplier.CODEC.optionalFieldOf("shortcut").forGetter(Key::shortcutBinding), (App)Codec.STRING.optionalFieldOf("identifier").forGetter(k -> Optional.ofNullable(k.identifier))).apply((Applicative)instance, Key::fromCodec)), CExtraCodecs.arrayPair(KeyFunction.CODEC, Key::regular, Key::shifted, Key::new));
        public static Codec<Key> CODEC = Codec.either(KeyFunction.CODEC, PAIR_CODEC).xmap(either -> (Key)either.map(Key::new, Function.identity()), Either::right);

        public Key(KeyFunction keyFunction) {
            this(keyFunction, keyFunction.createShifted());
        }

        public Key(KeyFunction keyFunction, float width) {
            this(keyFunction, width, Optional.empty());
        }

        public Key(KeyFunction keyFunction, float width, Optional<InputBindingSupplier> shortcut) {
            this(keyFunction, keyFunction.createShifted(), width, shortcut, null);
        }

        public Key(KeyFunction regular, KeyFunction shifted) {
            this(regular, shifted, 1.0f, Optional.empty(), null);
        }

        private static Key fromCodec(KeyFunction regular, Optional<KeyFunction> shifted, float width, Optional<InputBindingSupplier> shortcut, Optional<String> identifier) {
            return new Key(regular, shifted.orElseGet(regular::createShifted), width, shortcut, identifier.orElse(null));
        }

        public KeyFunction getFunction(boolean shifted) {
            return shifted ? this.shifted : this.regular;
        }
    }

    public static sealed interface KeyFunction {
        public static final Codec<KeyFunction> CODEC = new Codec<KeyFunction>(){

            public <T> DataResult<T> encode(KeyFunction input, DynamicOps<T> ops, T prefix) {
                KeyFunction keyFunction = input;
                Objects.requireNonNull(keyFunction);
                KeyFunction keyFunction2 = keyFunction;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringFunc.class, CodeFunc.class, SpecialFunc.class, ChangeLayoutFunc.class}, (Object)keyFunction2, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        StringFunc stringKey = (StringFunc)keyFunction2;
                        yield StringFunc.CODEC.encode((Object)stringKey, ops, prefix);
                    }
                    case 1 -> {
                        CodeFunc codeKey = (CodeFunc)keyFunction2;
                        yield CodeFunc.CODEC.encode((Object)codeKey, ops, prefix);
                    }
                    case 2 -> {
                        SpecialFunc specialKey = (SpecialFunc)keyFunction2;
                        yield SpecialFunc.CODEC.encode((Object)specialKey, ops, prefix);
                    }
                    case 3 -> {
                        ChangeLayoutFunc changeLayoutKey = (ChangeLayoutFunc)keyFunction2;
                        yield ChangeLayoutFunc.CODEC.encode((Object)changeLayoutKey, ops, prefix);
                    }
                };
            }

            public <T> DataResult<Pair<KeyFunction, T>> decode(DynamicOps<T> ops, T input) {
                return Stream.of(StringFunc.CODEC, CodeFunc.CODEC, SpecialFunc.CODEC, ChangeLayoutFunc.CODEC).map(decoder -> decoder.decode(ops, input)).map(r -> r.map(p -> p.mapFirst(t -> (KeyFunction)((Object)t)))).filter(DataResult::isSuccess).findFirst().orElseGet(() -> DataResult.error(() -> "No decoder matched."));
            }
        };

        public class_2561 displayName();

        default public KeyFunction createShifted() {
            return this;
        }

        public record ChangeLayoutFunc(class_2960 layout, class_2561 displayName) implements KeyFunction
        {
            public static final Codec<ChangeLayoutFunc> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("layout").forGetter(ChangeLayoutFunc::layout), (App)class_8824.field_46597.fieldOf("display_name").forGetter(ChangeLayoutFunc::displayName)).apply((Applicative)instance, ChangeLayoutFunc::fromCodec));

            private static ChangeLayoutFunc fromCodec(class_2960 layout, class_2561 displayName) {
                return new ChangeLayoutFunc(layout, displayName);
            }
        }

        public record SpecialFunc(Action action) implements KeyFunction
        {
            public static final Codec<SpecialFunc> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3542.method_28140(Action::values).fieldOf("action").forGetter(SpecialFunc::action)).apply((Applicative)instance, SpecialFunc::new));

            @Override
            public class_2561 displayName() {
                return this.action().displayName();
            }

            public static enum Action implements class_3542
            {
                SHIFT("shift"),
                SHIFT_LOCK("shift_lock"),
                ENTER("enter"),
                BACKSPACE("backspace"),
                TAB("tab"),
                LEFT_ARROW("left_arrow"),
                RIGHT_ARROW("right_arrow"),
                UP_ARROW("up_arrow"),
                DOWN_ARROW("down_arrow"),
                COPY_ALL("copy_all"),
                PASTE("paste"),
                PREVIOUS_LAYOUT("previous_layout");

                private final String serialName;

                private Action(String serialName) {
                    this.serialName = serialName;
                }

                @NotNull
                public String method_15434() {
                    return this.serialName;
                }

                public class_2561 displayName() {
                    return class_2561.method_43471((String)("controlify.keyboard.special." + this.serialName));
                }
            }
        }

        public record CodeFunc(List<KeyCode> codes, class_2561 displayName) implements KeyFunction
        {
            public static final Codec<CodeFunc> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)KeyCode.CODEC.listOf().fieldOf("codes").forGetter(CodeFunc::codes), (App)class_8824.field_46597.fieldOf("display_name").forGetter(CodeFunc::displayName)).apply((Applicative)instance, CodeFunc::new));

            record KeyCode(int keycode, int scancode, int modifier) {
                public static final Codec<KeyCode> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("keycode").forGetter(KeyCode::keycode), (App)Codec.INT.optionalFieldOf("scancode", (Object)0).forGetter(KeyCode::scancode), (App)Codec.INT.optionalFieldOf("modifier", (Object)0).forGetter(KeyCode::modifier)).apply((Applicative)instance, KeyCode::new)), (Codec)Codec.INT.xmap(keycode -> new KeyCode((int)keycode, 0, 0), KeyCode::keycode));

                public KeyCode(int keycode) {
                    this(keycode, 0, 0);
                }
            }
        }

        public record StringFunc(String string, @Nullable class_2561 manualDisplayName) implements KeyFunction
        {
            public static final Codec<StringFunc> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("chars").forGetter(StringFunc::string), (App)class_8824.field_46597.optionalFieldOf("display_name").forGetter(k -> Optional.of(k.displayName()))).apply((Applicative)instance, StringFunc::fromCodec)), (Codec)Codec.STRING.xmap(StringFunc::new, StringFunc::string));

            public StringFunc(String string) {
                this(string, null);
            }

            private static StringFunc fromCodec(String string, Optional<class_2561> displayName) {
                return new StringFunc(string, displayName.orElse(null));
            }

            @Override
            public class_2561 displayName() {
                return this.manualDisplayName != null ? this.manualDisplayName : class_2561.method_43470((String)this.string);
            }

            @Override
            public KeyFunction createShifted() {
                return new StringFunc(this.string.toUpperCase(), this.manualDisplayName);
            }
        }
    }
}

